require( "quest/napkin/convout.lua" );
combine_speech_tables();

local click_count = 0;
local debug_test_complete = false;

napkin_data = 
{
	{ napkin = "NAPKIN1", depth = 300, children = { } },
	{ napkin = "NAPKIN2", depth = 200, children = { } },
	{ napkin = "NAPKIN3", depth = 100, children = { } },
}

napkin_quests = 
{
	-- name = quest_name, x = x_pos, y = y_pos, lineheight = lineheight of text
	-- name must correspond to: "complete_name.png", "name.png" for images and 
	-- "napkin_name" for text in the string_napkin.xml
	-- quest variables are called "napkin_name" and are set with add_quest and compelte_quest and checked
	-- with quest_added and quest_complete

	-- napkin 1
	{
		-- Poodle tasks
		{ name = "find_snookums", x = 148, y = 54, lineheight = 28 },
		{ name = "need_dye_remover", x = 148, y = 94},
		{ name = "check_with_betty", x = 148, y = 133, w = 150},
		{ name = "betty_needs_dye", x = 148, y = 175 },
		{ name = "red_bottle", x = 148, y = 205 },
		{ name = "dianes_window", x = 148, y = 230 },
		{ name = "check_with_walter", x = 381, y = 58, w = 240 },
		{ name = "give_derek_coffee", x = 330, y = 94 },
		{ name = "give_diane_oil", x = 330, y = 133 },
		{ name = "give_betty_dye", x = 330, y = 160 },
		{ name = "check_supply_drawers", x = 330, y = 185 },
		{ name = "bring_dye_to_petspa", x = 330, y = 230 },
		{ name = "lure_snookums", x = 526, y = 94 },
		{ name = "need_dog_treats", x = 526, y = 122},
		{ name = "got_dog_treats", x = 526, y = 166 },
		{ name = "give_walter_snookums", x = 526, y = 195 },
		
		-- Dress tasks
		{ name = "wedding_dress", x = 148, y = 274, lineheight = 28 },
		{ name = "check_with_bobbi", x = 315, y = 280, w = 250},
		{ name = "find_beads", x = 148, y =  306},
		{ name = "fix_beadmachine", x = 148, y =  334},
		{ name = "find_screwdriver", x = 148, y =  368},
		{ name = "find_beadmachine_code", x = 148, y =  396},
		{ name = "do_beadwork", x = 148, y = 422 },
		{ name = "need_beads", x =335, y =  308},
		{ name = "need_wirecutters", x = 335, y =  335},
		{ name = "give_ethel_wirecutters", x = 335, y = 391},
		{ name = "finish_beading", x = 335, y = 422 },
		{ name = "need_lace", x = 526, y = 306},
		{ name = "beauty_curtains", x = 526, y = 335},
		{ name = "use_pole", x = 526, y = 380},
		{ name = "need_pole", x = 526, y = 422},
		
		-- Butterfly tasks
		{ name = "collect_butterflies1", x = 148, y = 449, w = 400, lineheight = 28 },
		{ name = "butterfly_bag", x = 196, y = 478, w = 500},
	},
	
	-- napkin 2
	{
		{ name = "cake", x = 310, y = 62, lineheight = 28 },
		
		--Bakery Tasks
		{ name = "check_with_stella", x = 162, y = 100, w = 500 },
		{ name = "get_recipe", x = 162, y = 125, w = 400 },
		{ name = "get_ingredients", x = 162, y = 150, w = 400 },
		{ name = "get_eggs", x = 162, y = 180, w = 400 },
		{ name = "use_eggs", x = 185, y = 313, w = 400 },
		{ name = "get_cake_instructions", x = 294, y = 343, w = 400 },		
		
		--Farm Tasks
		{ name = "check_farm", x = 185, y = 205 },
		{ name = "get_lugnuts", x = 185, y = 230 },
		{ name = "pass_chickenchorus", x = 185, y = 260 },
		{ name = "pass_chickenfield", x = 185, y = 285, w = 400 },
		
		
		{ name = "use_cake_instructions", x = 294, y = 368 },
		{ name = "pass_aerobics", x = 294, y = 410, w = 400 },
		{ name = "info_cake_code", x = 507, y = 398},
		{ name = "info_vcr", x = 507, y = 368},
		{ name = "get_cookies", x = 404, y = 180, w = 400 },
		{ name = "pass_girl_sprouts", x = 404, y = 205, w = 400 },
		{ name = "use_cookies", x = 404, y = 230, w = 400 },
		
		-- Butterfly tasks
		{ name = "collect_butterflies2", x = 148, y = 449, w = 500, lineheight = 28 },
	},
	
	-- napkin 3
	{
		{ name = "flowers", x = 172, y = 61, linepadding = 2, w = 400, lineheight = 28 },
		{ name = "rings", x = 172, y = 188, w = 500, lineheight = 28 },
		
		{ name = "check_with_marco", x = 172, y = 96, w = 500 },
		{ name = "find_flowers", x = 172, y = 119, w = 500 },
		{ name = "arrange_bouquets", x = 172, y = 142, w = 500 },
		{ name = "find_bernie", x = 172, y = 223, w = 500 },
		{ name = "rings_locked", x = 172, y = 246, w = 500 },
		{ name = "find_code_paper", x = 172, y = 271, w = 500 },
		{ name = "give_permit", x = 172, y = 296, w = 500 },
		{ name = "keycard1", x = 172, y = 321, w = 500 },
		{ name = "got_permit", x = 172, y = 342, w = 500 },
		{ name = "keycard2", x = 172, y = 366, w = 500 },
		{ name = "make_copy", x = 172, y = 390, w = 500 },
		{ name = "unlock_drawer", x = 484, y = 222, w = 500 },
		{ name = "find_revealer", x = 484, y = 246, w = 500 },
		{ name = "figure_out_clues", x = 484, y = 270, w = 500 },
		{ name = "code_number", x = 533, y = 296, w = 500},
		{ name = "got_rings", x = 484, y = 355, w = 130, linepadding = 3},
		
		-- Butterfly tasks
		{ name = "collect_butterflies3", x = 172, y = 452, w = 500, lineheight = 28 },
	}
}

local napkin_item_spawning = 0; -- to only spawn one item at a time
local napkin_quests_spawning = 1;

function napkin_module_complete(module_progress)
	if module_progress == 1 then
		if debug_test_complete then
			return true;
		else
			return quest_complete("find_snookums") and quest_complete("wedding_dress") and quest_complete("collect_butterflies1");
		end
	elseif module_progress == 2 then
		return quest_complete("cake") and quest_complete("collect_butterflies2");
	else -- module_progress == 3
		return false;
	end
end

function spawn_napkin_quests()
	xprint("spawn_napkin_quests() in\n");
	local napkin_quest_total = table.getn(napkin_quests);
	local module_progress = game:Get("napkin_module_progress");

	for i=napkin_quest_total, 1, -1 do
		if module_progress == i then
			-- spawn all items that come up instantly
			for j,w in napkin_quests[i] do
				if game:Get("napkin_" .. w.name) > 1 then
					table.insert(napkin_data[i].children, scene:Spawn(get_napkin_quest_spec(w, i)));
				end
			end
		end
	end;
	
	local top_napkin = game:Get("top_napkin");
	local next_napkin = game:Get("next_napkin");
	
	if next_napkin < 1 then
		next_napkin = 2;
	end
	
	if top_napkin < 1 then
		top_napkin = 1;
	end
	
	coroutine.yield(RESUME.NOW); -- give napkins a chance to spawn
	scene["NAPKIN" .. next_napkin]:StartProc(sort_napkins);
	scene["NAPKIN" .. top_napkin]:StartProc(sort_napkins);
	
	-- now lets wait and pop up everything that pops up when the napkin is full size
	wait_fade();
	
	scene:SetDrawEnvSlideSpeed(0.06);
	
	while not scene:IsDrawEnvSlideDone() do
		delay(1);
	end
	
	if not scene.FLO then
		spawn_button(pause_button_help_spec);
		spawn_button(back_button_spec);
		spawn_help_panel();
		scene:Spawn(flo_spec);
	end
	
	click_count = 0;
	
	for i=napkin_quest_total, 1, -1 do
		if module_progress == i then
			-- spawn all completed quests
			local napkin_total = table.getn(napkin_quests[i]);
			for j=napkin_total, 1, -1 do
			--for j,w in napkin_quests[i] do
				if game:Get("napkin_" .. napkin_quests[i][j].name) == 3 then
					-- make sure this napkin is at the top
					if top_napkin ~= i then
						scene["NAPKIN" .. i]:StartProc(sort_napkins);
						next_napkin = top_napkin;
						top_napkin = i;
					end
					
					napkin_item_spawning = 1;
					cross_off_napkin(napkin_quests[i][j], i);
					while napkin_item_spawning == 1 do
						delay(1);
					end
				end
			end
			
			-- spawn all new quests
			for j,w in napkin_quests[i] do
				if game:Get("napkin_" .. w.name) == 1 then
					-- make sure this napkin is at the top
					if top_napkin ~= i then
						scene["NAPKIN" .. i]:StartProc(sort_napkins);
						next_napkin = top_napkin;
						top_napkin = i;
					end
					
					napkin_item_spawning = 1;
					table.insert(napkin_data[1].children, scene:Spawn(get_napkin_quest_spec(w, i)));
					while napkin_item_spawning == 1 do
						delay(1);
					end
				end
			end
			
			-- napkins 1 & 2 are initially invisible on first run
			if game:Get("first_time_napkin") < 1 then
				--coroutine.yield(RESUME.ON_CLICK);
				--coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
				click_count = 0;
				
				if i == 3 then
					help_panel_say_raw(scene:grabstring("napkin_intro_message2"));
				elseif i == 2 then
					help_panel_say_raw(scene:grabstring("napkin_intro_message3"));
				end
			end
		end
	end
	
	if game:Get("florida_tutorial") == 2 or game:Get("florida_tutorial") == 6 then
		scene:Spawn(tutorial_dialog_spec);
	end
	
	game:Set("top_napkin", top_napkin);
	game:Set("next_napkin", next_napkin);
	
	if game:Get("napkin_find_snookums") == 4 then
		spawn_task_complete_spec("FIND_SNOOKUMS_TEXT", "napkin_snookums_complete");
		coroutine.yield(RESUME.ON_SIGNAL);
		game:Set("napkin_find_snookums", 5);
		scene.FIND_SNOOKUMS_TEXT:Expire();
	end
	
	if game:Get("napkin_wedding_dress") == 4 then
		spawn_task_complete_spec("DRESS_TEXT", "napkin_dress_complete");
		coroutine.yield(RESUME.ON_SIGNAL);
		game:Set("napkin_wedding_dress", 5);
		scene.DRESS_TEXT:Expire();
	end
	
	if game:Get("napkin_collect_butterflies1") == 4 then
		spawn_task_complete_spec("BUTTERFLIES1_TEXT", "napkin_butterflies1_complete");
		coroutine.yield(RESUME.ON_SIGNAL);
		game:Set("napkin_collect_butterflies1", 5);
		scene.BUTTERFLIES1_TEXT:Expire();
	end
	
	if game:Get("napkin_cake") == 4 then
		spawn_task_complete_spec("CAKE_TEXT", "napkin_cake_complete");
		coroutine.yield(RESUME.ON_SIGNAL);
		game:Set("napkin_cake", 5);
		scene.CAKE_TEXT:Expire();
	end
	
	if game:Get("napkin_collect_butterflies2") == 4 then
		spawn_task_complete_spec("BUTTERFLIES2_TEXT", "napkin_butterflies2_complete");
		coroutine.yield(RESUME.ON_SIGNAL);
		game:Set("napkin_collect_butterflies2", 5);
		scene.BUTTERFLIES2_TEXT:Expire();
	end
	
	if game:Get("napkin_flowers") == 4 then
		spawn_task_complete_spec("FLOWERS_TEXT", "napkin_flowers_complete");
		coroutine.yield(RESUME.ON_SIGNAL);
		game:Set("napkin_flowers", 5);
		scene.FLOWERS_TEXT:Expire();
	end
	
	if game:Get("napkin_figure_out_clues") == 4 then
		spawn_task_complete_spec("CODE_TEXT", "napkin_code_complete");
		coroutine.yield(RESUME.ON_SIGNAL);
		game:Set("napkin_figure_out_clues", 5);
		scene.CODE_TEXT:Expire();
	end
	
	if game:Get("napkin_rings") == 4 then
		spawn_task_complete_spec("RINGS_TEXT", "napkin_rings_complete");
		coroutine.yield(RESUME.ON_SIGNAL);
		game:Set("napkin_rings", 5);
		scene.RINGS_TEXT:Expire();
	end
	
	if game:Get("napkin_collect_butterflies3") == 4 then
		spawn_task_complete_spec("BUTTERFLIES3_TEXT", "napkin_butterflies3_complete");
		coroutine.yield(RESUME.ON_SIGNAL);
		game:Set("napkin_collect_butterflies3", 5);
		scene.BUTTERFLIES3_TEXT:Expire();
	end
	
	-- check if a module is complete
	if napkin_module_complete(module_progress) then
		game:Set("napkin_module_progress", module_progress + 1);
		
		spawn_task_complete_spec("NAPKIN_COMPLETE", "napkin_complete");
		
		coroutine.yield(RESUME.ON_SIGNAL);
		
		scene["NAPKIN" .. module_progress]:StartProc(shift_off);
		scene["NAPKIN" .. (module_progress +1)]:StartProc(shift_on);
		
		coroutine.yield(RESUME.ON_SIGNAL);
		
		spawn_napkin_quests();
	else
		napkin_quests_spawning = 0;
	end
	
	xprint("spawn_napkin_quests() out\n");
end

function cross_off_napkin(quest_data, napkin_num)
	local napkin_name = string.upper(quest_data.name);
	if click_count < 1 then
		delay(30);
	end
	sfx:PlaySFX("audio/sfx/checklist_cross_off.ogg");
	
	scene[napkin_name]:LoadImage("complete_" .. quest_data.name);
	
	--flash 4 times
	for i = 1,4 do
		scene[napkin_name]:ModifySaySpec { color = { a = 1, r = 0.5, g = 0.5, b = 0.5 } }
		scene[napkin_name]:Say("napkin_" .. quest_data.name);
		if click_count < 1 then
			delay(5);
		end
		scene[napkin_name]:ModifySaySpec { color = { a = 1, r = 0, g = 0, b = 0 } }
		scene[napkin_name]:Say("napkin_" .. quest_data.name);
		if click_count < 1 then
			delay(5);
		end
	end
	
	scene[napkin_name]:ModifySaySpec { color = { a = 1, r = 0.5, g = 0.5, b = 0.5 } }
	scene[napkin_name]:Say("napkin_" .. quest_data.name);
	
	if click_count < 1 then
		delay(20);
	end
	
	game:Set("napkin_" .. quest_data.name, 4)
	napkin_item_spawning = 0;
end

function get_napkin_quest_spec(quest_data, napkin_num)
	return
	{
		
		name = string.upper(quest_data.name);
		
		command = function(actor)
			actor:ModifySaySpec(napkin_say_spec);
			actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
			actor:AddFlag(AFLAG.AFLAG_NO_VOX);
			actor:ModifySaySpec { x = quest_data.x, y = quest_data.y };
			
			if quest_data.lineheight ~= nil then
				actor:ModifySaySpec { lineheight = quest_data.lineheight };
			end
			
			if quest_data.w ~= nil then
				actor:ModifySaySpec { w = quest_data.w };
			end
			
			if quest_data.linepadding ~= nil then
				actor:ModifySaySpec { linepadding = quest_data.linepadding };
			end
			
			local quest_value = game:Get("napkin_" .. quest_data.name);
			
			if quest_value < 2 then
				--scene:SetMode(MODE.CUTSCENE);
				if click_count < 1 then
					delay(30);
				end
				actor:Say("napkin_" .. quest_data.name);
				actor:AltTextToImage();
				sfx:PlaySFX("audio/sfx/checklist_new_task.ogg");
				--actor.gfx = { image = tostring(quest_data.name)};
				actor:LoadImage(quest_data.name);
				
				--flash 4 times
				for i = 1,4 do
					actor:SetAlpha(0);
					if click_count < 1 then
						delay(5);
					end
					actor:SetAlpha(1);
					if click_count < 1 then
						delay(5);
					end
				end
				
				game:Set("napkin_" .. quest_data.name, 2)
				
				--scene:SetMode(MODE.FOLLOWCLICKS);
			elseif quest_value < 4 then
				actor:Say("napkin_" .. quest_data.name);
				actor:AltTextToImage();
				--actor.gfx = { image = tostring(quest_data.name)};
				actor:LoadImage(quest_data.name);
				actor:SetDepthValue(napkin_data[napkin_num].depth + 1);
			else
				actor:ModifySaySpec { color = { a = 1, r = 0.5, g = 0.5, b = 0.5 } }
				actor:Say("napkin_" .. quest_data.name);
				actor:AltTextToImage();
				actor:LoadImage("complete_" .. quest_data.name);
				actor:SetDepthValue(napkin_data[napkin_num].depth + 1);
			end

			napkin_item_spawning = 0;
		end;
	}
end

napkin_say_spec = 
{
	font = "fonts/graphite_std.mvec",
	lineheight = 18,
	color = { a = 1, r = 0, g = 0, b = 0 },
	outline_size = 0,
	bubble = false,
	anchor = ANCHOR.TOP,
	halign = HALIGN.LEFT,
	fixed = true,
	w = 200,
	h = 200,
	linepadding = -3
};

flo_spec =
{
	name = "FLO";

	command = function(actor)
		actor:ModifySaySpec(flo_text_spec)
		coroutine.yield(RESUME.NOW);
		scene.BACK_BUTTON:Expire();
		if game:Get("first_time_napkin") < 1 then
			--spawn_help_panel();
			help_panel_say_raw(scene:grabstring("napkin_intro_message3"));
			
			while napkin_quests_spawning == 1 do
				delay(1);
			end;
			
			game:Set("first_time_napkin", 1);
			
			--scene["NAPKIN2"]:StartProc(sort_napkins);
			--coroutine.yield(RESUME.NOW);
			--scene["NAPKIN1"]:StartProc(sort_napkins);
			--coroutine.yield(RESUME.NOW);
			
			--game:Set("top_napkin", 1);
			--game:Set("next_napkin", 2);
			
			coroutine.yield(RESUME.ON_CLICK);
			
			actor:StartProc(go_back);
		else
			scene.HELP_PANEL:Expire();
			scene.HELP_PANEL_BLINK:Expire();
		
			if game:Get("florida_tutorial") == 2 or game:Get("florida_tutorial") == 6 then
				
				while napkin_quests_spawning == 1 do
					delay(1);
				end;
				coroutine.yield(RESUME.ON_CLICK);
				actor:StartProc(go_back);
			else
				while napkin_quests_spawning == 1 do
					delay(1);
				end;
			end
			
			coroutine.yield(RESUME.ON_CLICK);
			
			actor:StartProc(go_back);
		end
	end;
};

tutorial_dialog_spec = 
{
	name = "TUTORIAL_DIALOG";
	gfx = { image = "quest/shared/tutorial_dialog_medium" };
	
	command = function(actor)
		actor:SetDepthValue(600);
		actor:JumpToPoint { x = 0, y = -60 };
		actor:ModifySaySpec
		{
			lineheight = 20,
			color = { a = 1, r = 0, g = 0, b = 0 },
			outline_size = 0,
			bubble = false,
			anchor = ANCHOR.TOP,
			halign = HALIGN.LEFT,
			x = 475,
			y = 350,
			w = 275,
			h = 250,
		};
		
		actor:Spawn(tutorial_dialog_arrow_spec);
		
		sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
		
		if game:Get("florida_tutorial") == 2 then
			actor:Say("napkin_tutorial_message_A");
		elseif game:Get("florida_tutorial") == 6 then
			actor:Say("napkin_tutorial_message_B");
		end
		
		coroutine.yield(RESUME.ON_CLICK);
		actor:Expire();
		scene.TUTORIAL_DIALOG_ARROW:Expire();
	end
}

tutorial_dialog_arrow_spec = 
{
	name = "TUTORIAL_DIALOG_ARROW";
	gfx = { image = "arrow_bag_tutorial" };
	
	command = function(actor)
		actor:SetDepthValue(605);
	end
}

function sort_napkins(napkin)
	local i = table.getn(napkin_data);
	
	xprint("sort_napkins", napkin);
	
	-- bubble napkin to the top
	while i > 1 do
		if napkin_data[i].napkin == napkin.name then
			local tmp = napkin_data[i].children;
			napkin_data[i].napkin = napkin_data[i-1].napkin;
			napkin_data[i].children = napkin_data[i-1].children;
			napkin_data[i-1].napkin = napkin.name;
			napkin_data[i-1].children = tmp;
		end;
		i = i - 1;
	end
	
	for i,v in pairs(napkin_data) do
		scene[v.napkin]:SetDepthValue(v.depth);
		for j,w in pairs(v.children) do
			w:SetDepthValue(v.depth + (j));
		end
	end;
end;

function shift_off(napkin)
	local i = table.getn(napkin_data);
	
	while i > 0 do
		if napkin_data[i].napkin == napkin.name then
			local napkin_children = napkin_data[i].children;
			
			local shift_dist = 800;
			local cur_dist = 0;
			local move_speed = 10;
			
			while cur_dist < shift_dist do
				move_actor_x(napkin, -move_speed);
				move_actor_x(scene.NAPKIN_COMPLETE, -move_speed);
				for j,w in pairs(napkin_children) do
					move_actor_x(w, -move_speed);
				end
				cur_dist = cur_dist + move_speed;
				delay(1);
			end
			
			napkin:SetAlpha(0);
			scene.NAPKIN_COMPLETE:SetAlpha(0);
			for j,w in pairs(napkin_children) do
				w:SetAlpha(0);
			end
			
			break;
		end
		i = i - 1;
	end
	
	scene.SETUP:Signal();
end

function shift_on(napkin)
	local i = table.getn(napkin_data);
	
	while i > 0 do
		if napkin_data[i].napkin == napkin.name then
			local napkin_children = napkin_data[i].children;
			
			local shift_dist = 800;
			local cur_dist = 0;
			local move_speed = 10;
			local position = napkin:GetPosition();
			
			sfx:PlaySFX("audio/sfx/checklist_zoom1.ogg");
			
			napkin:SetAlpha(1);
			napkin:JumpToPoint { x = position.x + shift_dist, y = position.y };
			for j,w in pairs(napkin_children) do
				w:SetAlpha(1);
				position = w:GetPosition();
				w:JumpToPoint { x = position.x + shift_dist, y = position.y };
			end
			
			while cur_dist < shift_dist do
				move_actor_x(napkin, -move_speed);
				for j,w in pairs(napkin_children) do
					move_actor_x(w, -move_speed);
				end
				cur_dist = cur_dist + move_speed;
				delay(1);
			end

			break;
		end
		i = i - 1;
	end
	
	scene.SETUP:Signal();
end

napkin1_spec = 
{
	name = "NAPKIN1";
	gfx = { image = "napkin_1" };
	halo = "napkin1";
	
	command = function(actor)
		actor:SetDepthValue(napkin_data[1].depth);
		actor:SetPointAtCursor("cursor");
		
		if game:Get("napkin_module_progress") ~= 1 then
			actor:SetAlpha(0);
			actor:DumpZone();
		end
	end;
	
	on_arrive = function(flo, actor)
		if game:Get("top_napkin") ~= 1 then
			game:Set("next_napkin", game:Get("top_napkin"));
			game:Set("top_napkin", 1);
			actor:StartProc(sort_napkins);
		end
	end;
}

napkin2_spec = 
{
	name = "NAPKIN2";
	gfx = { image = "napkin_2" };
	halo = "napkin2";
	
	command = function(actor)
		actor:SetDepthValue(napkin_data[2].depth);
		actor:SetPointAtCursor("cursor");
		
		if game:Get("napkin_module_progress") ~= 2 then
			actor:SetAlpha(0);
			actor:DumpZone();
		end
	end;
	
	on_arrive = function(flo, actor)
		if game:Get("top_napkin") ~= 2 then
			game:Set("next_napkin", game:Get("top_napkin"));
			game:Set("top_napkin", 2);
			actor:StartProc(sort_napkins);
		end
		actor:StartProc(sort_napkins);
	end;
}

napkin3_spec = 
{
	name = "NAPKIN3";
	gfx = { image = "napkin_3" };
	halo = "napkin3";
	
	command = function(actor)
		actor:SetDepthValue(napkin_data[3].depth);
		actor:SetPointAtCursor("cursor");
		
		if game:Get("napkin_module_progress") ~= 3 then
			actor:SetAlpha(0);
			actor:DumpZone();
		end
	end;
	
	on_arrive = function(flo, actor)
		if game:Get("top_napkin") ~= 3 then
			game:Set("next_napkin", game:Get("top_napkin"));
			game:Set("top_napkin", 3);
			actor:StartProc(sort_napkins);
		end
		actor:StartProc(sort_napkins);
	end;
}

function spawn_task_complete_spec(name, text) 
	return scene:Spawn
	{
		name = name;
		
		command = function(actor)
			actor:ModifySaySpec(napkin_say_spec);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 1, g = 0, b = 0},
				fixed = true,
				lineheight = 50,
				anchor = ANCHOR.TOP,
				halign = HALIGN.CENTER,
				font = "fonts/dom_casual_std.mvec",
				outline_size = 1,
				outline_color = { a = 1, r = 0, g = 0, b = 0 },
				w = 2400
			};
			actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
			actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
			actor:AddFlag(AFLAG.AFLAG_NO_VOX);
			actor:JumpToPoint{ x = 400, y = 300 };
			actor:LoadPartyContainer("fx/afpfx_explosion_fireworks.lua");
			actor:ModifySaySpec { x = -1200, y = -100 };
			--sfx:PlaySFX("audio/sfx/door_close");
			
			local end_size = 70;
			local start_size = 300;
			local inc = 10;
			local cur_size = start_size;
			
			actor:ModifySaySpec { h = start_size };
			actor:AltTextToImage();
			
			while cur_size > end_size do
				actor:ModifySaySpec { lineheight = cur_size, color = { a = 1-((cur_size-end_size)/(start_size-end_size)), r = 1, g = 0, b = 0 } };
				actor:Say(text);
				cur_size = cur_size - inc;
				delay(1);
			end
			
			local flash_amount = 4;
			local flash_delay = 5;
			local flash_count = 0;
			
			delay(flash_delay);
			
			sfx:PlaySFX("audio/sfx/complete_box");
			
			while flash_count < flash_amount do
				actor:ModifySaySpec { color = { a = 0, r = 1, g = 0, b = 0 }, outline_size = 0 };
				actor:Say(text);
				delay(flash_delay);
				actor:ModifySaySpec { color = { a = 1, r = 1, g = 0, b = 0 }, outline_size = 1 };
				actor:Say(text);
				delay(flash_delay);
				flash_count = flash_count + 1;
			end
			
			delay(30);
			
			--actor:AltTextToImage();
			coroutine.yield(RESUME.ON_CLICK, RESUME.ON_DELAY, 60);
			scene.SETUP:Signal();
		end;
	};
end

function go_back(flo)
	flo:SetMode(MODE.CUTSCENE);
	kill_help_panel();
	scene:SetDrawEnvSlideSpeed(-0.06);
	sfx:PlaySFX("audio/sfx/checklist_zoom2.ogg");
	--raise_hud();
	
	while not scene:IsDrawEnvSlideDone() do
		delay(1);
	end
	
	if game:Get("florida_tutorial") == 2 then
		game:Set("florida_tutorial", 3);
	end
	
	scene:ReturnFromScene();
end;

back_spec = 
{
	name = "BACK";
	halo = "background";
	--point_at_name = "back";
	--point_at_color = { a  = 1, r = 1, g = 0, b = 0 };
	
	command = function(actor)
		actor:SetDepthValue(0);
		actor:SetPointAtCursor("cursor_exit");
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(go_back);
	end;
	
	on_use_inv = function(item, flo, actor)
		return RESPONSE.INV_HANDLED;
	end;
}

click_counter_spec = 
{
	name = "CLICK_COUNTER";
	
	command = function(actor)
		while true do
			coroutine.yield(RESUME.ON_CLICK);
			click_count = click_count + 1;
		end;
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			--testing
			--[[game:Set("napkin_butterfly_bag", 1);
			game:Set("napkin_snookums_tick", 1);
			game:Set("napkin_find_snookums", 1);
			game:Set("napkin_need_dye_remover", 1);
			game:Set("napkin_check_with_betty", 1);
			game:Set("napkin_betty_needs_dye", 1);
			game:Set("napkin_red_bottle", 1);
			game:Set("napkin_dianes_window", 1);
			game:Set("napkin_check_with_walter", 1);
			game:Set("napkin_give_derek_coffee", 1);
			game:Set("napkin_give_diane_oil", 1);
			game:Set("napkin_give_betty_dye", 1);
			game:Set("napkin_check_supply_drawers", 1);
			game:Set("napkin_bring_dye_to_petspa", 1);
			
			game:Set("napkin_lure_snookums", 1);
			game:Set("napkin_need_dog_treats", 1);
			game:Set("napkin_got_dog_treats", 1);
			game:Set("napkin_give_walter_snookums", 1);
			
			complete_quest("lure_snookums");
			complete_quest("need_dog_treats");
			complete_quest("got_dog_treats");
			complete_quest("give_walter_snookums", 1);
			
			game:Set("napkin_check_with_bobbi", 1);
			
			
			
			game:Set("napkin_finish_beading", 1);
			game:Set("napkin_need_lace", 1);
			game:Set("napkin_beauty_curtains", 1);
			game:Set("napkin_need_pole", 1);
			game:Set("napkin_use_pole", 1);
			game:Set("napkin_napkin_butterfly_bag", 1);
			game:Set("napkin_napkin_butterfly_bag", 1);
			
			complete_quest("check_with_bobbi");
			
			game:Set("first_time_napkin", 1);]]--
			
			--game:Set("napkin_give_walter_snookums", 1);
			--complete_quest("give_walter_snookums");
			
			--game:Set("napkin_wedding_dress", 1);
			
			--game:Set("napkin_napkin_collect_butterflies", 1);
		--[[
			game:Set("napkin_check_with_stella", 3);
			game:Set("napkin_get_recipe",3);
			game:Set("napkin_get_ingredients", 3);
			game:Set("napkin_get_eggs", 3);
			game:Set("napkin_use_eggs", 3);
			game:Set("napkin_get_cake_instructions", 3);
			
		--	game:Set("napkin_cake", 3);
		--	game:Set("napkin_info_vcr", 1);
		--	game:Set("napkin_info_cake_code", 1);
			
			--Farm Tasks
			game:Set("napkin_check_farm", 3);
			game:Set("napkin_get_lugnuts", 3);
			game:Set("napkin_pass_chickenchorus", 3);
			game:Set("napkin_pass_chickenfield", 3);
			
			
			game:Set("napkin_use_cake_instructions", 3);
			game:Set("napkin_pass_aerobics", 3);
			
			
			
			
			
			
			game:Set("napkin_get_cookies", 3);
			
			game:Set("napkin_use_cookies", 3);]]--[[
			complete_quest("wedding_dress");
			complete_quest("cake");
			complete_quest("get_cake_instructions");
			complete_quest("get_recipe");
			complete_quest("check_farm");
			complete_quest("get_cookies");
			
			game:Set("napkin_cake", 4);
			
			--Bakery Tasks
			game:Set("napkin_check_with_stella", 4);
			game:Set("napkin_get_recipe", 4);
			game:Set("napkin_get_ingredients", 4);
			game:Set("napkin_get_eggs", 4);
			game:Set("napkin_use_eggs", 4);
			game:Set("napkin_get_cake_instructions", 4);	
			
			--Farm Tasks
			game:Set("napkin_check_farm", 4);
			game:Set("napkin_get_lugnuts", 4);
			game:Set("napkin_pass_chickenchorus", 4);
			game:Set("napkin_pass_chickenfield", 4);
			
			game:Set("napkin_use_cake_instructions", 4);
			game:Set("napkin_pass_aerobics", 4);
			game:Set("napkin_info_cake_code", 4);
			game:Set("napkin_info_vcr", 4);
			game:Set("napkin_get_cookies", 4);
			game:Set("napkin_pass_girl_sprouts", 4);
			game:Set("napkin_use_cookies", 4);
			
			game:Set("napkin_flowers", 4);
			game:Set("napkin_rings", 4);
			game:Set("napkin_check_with_marco", 4);
			game:Set("napkin_find_flowers", 4);
			
			game:Set("napkin_arrange_bouquets", 4);
			game:Set("napkin_find_bernie", 4);
			game:Set("napkin_rings_locked", 4);
			game:Set("napkin_find_code_paper", 4);
			game:Set("napkin_give_permit", 4);
			game:Set("napkin_keycard1", 4);
			game:Set("napkin_got_permit", 4);
			game:Set("napkin_keycard2", 4);
			game:Set("napkin_make_copy", 4);
			game:Set("napkin_unlock_drawer", 4);
			game:Set("napkin_find_revealer", 4);
			game:Set("napkin_figure_out_clues", 4);
			game:Set("napkin_code_number", 4);
			game:Set("napkin_got_rings", 4);
			game:Set("napkin_collect_butterflies3", 4);
			]]
		end
		
		sfx:PlaySFX("audio/sfx/checklist_zoom1.ogg");
		
		scene:SetDrawEnvSlidePos(0.0);
		scene:SetCameraFollowActor(nil);
		
		game:Set("got_napkin", 1);
		
		if game:Get("napkin_module_progress") < 1 then
			game:Set("napkin_module_progress", 1);
		end
		
		if game:Get("module_progress") > game:Get("napkin_module_progress") then
			game:Set("napkin_module_progress", game:Get("module_progress"));
		end
		
		fade_scene_up(true, true);
		scene.PAUSE_BUTTON_HELP:Expire()
		scene.BACK_BUTTON:Expire();
		lower_hud();
		game:ClearInvUsage();
		
		-- make sure to spawn initial quests
		if game:Get("napkin_find_snookums") < 1 then 
			game:Set("napkin_find_snookums", 1);
			game:Set("napkin_check_with_walter", 1);
			game:Set("napkin_collect_butterflies1", 1);
			game:Set("napkin_wedding_dress", 1);
			game:Set("napkin_check_with_bobbi", 1);
		end
		
		if game:Get("napkin_cake") < 1 then
			game:Set("napkin_cake", 1);
			game:Set("napkin_check_with_stella", 1);
			game:Set("napkin_collect_butterflies2", 1);
		end
		
		if game:Get("napkin_rings") < 1 then
			game:Set("napkin_rings", 1);
			game:Set("napkin_flowers", 1);
			game:Set("napkin_check_with_marco", 1);
			game:Set("napkin_collect_butterflies3", 1);
		end
		
		scene:Spawn(click_counter_spec);
		
		MET_Count("NapkinVisited");
		
		spawn_napkin_quests();
		
		--sort_napkins(scene.NAPKIN1);
		
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces",
		"pieces2",
	};
	
	bg_image = 
	{
		--{ "background", 1 },
	};
	
	ground = "background";
	
	actorlist = 
	{ 
		scene_setup,
		napkin1_spec,
		napkin2_spec,
		napkin3_spec,
		--flo_spec,
		--back_spec,
	};
};
